/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.util;

public class Color {
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f);
    public float a;
    public float r;
    public float g;
    public float b;

    public Color() {
        this(1.0f, 1.0f, 1.0f);
    }

    public Color(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public Color(int red, int green, int blue) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
    }

    public Color(Color copy) {
        this(copy.r, copy.g, copy.b);
    }

    public int getIntRed() {
        return (int)(this.r * 255.0f);
    }

    public int getIntGreen() {
        return (int)(this.g * 255.0f);
    }

    public int getIntBlue() {
        return (int)(this.b * 255.0f);
    }

    public int getIntAlpha() {
        return (int)(this.a * 255.0f);
    }

    public float getValue() {
        return Math.max(Math.max(this.r, this.g), this.b);
    }

    public String toHexString() {
        return String.format("%02X%02X%02X%02X", this.getIntRed(), this.getIntGreen(), this.getIntBlue(), this.getIntAlpha());
    }

    public void power(float p) {
        this.r = (float)Math.pow(this.r, p);
        this.g = (float)Math.pow(this.g, p);
        this.b = (float)Math.pow(this.b, p);
        this.clamp();
    }

    public void average(Color c, float weight) {
        this.r = this.r * (1.0f - weight) + c.r * weight;
        this.g = this.g * (1.0f - weight) + c.g * weight;
        this.b = this.b * (1.0f - weight) + c.b * weight;
        this.a = this.a * (1.0f - weight) + c.a * weight;
        this.clamp();
    }

    public void addWhite(float w) {
        Color white = new Color();
        this.average(white, w);
    }

    public void multiply(Color c) {
        this.r *= c.r;
        this.g *= c.g;
        this.b *= c.b;
        this.a *= c.a;
        this.clamp();
    }

    private void clamp() {
        this.r = Math.max(0.0f, Math.min(this.r, 1.0f));
        this.g = Math.max(0.0f, Math.min(this.g, 1.0f));
        this.b = Math.max(0.0f, Math.min(this.b, 1.0f));
        this.a = Math.max(0.0f, Math.min(this.a, 1.0f));
    }
}

